@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.report_income')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                {!! Form::open(array('route' => 'history_delivery_print','method'=>'POST','target'=>"_blank")) !!}
                <div class="form-search">
                    @if(\Globals::is_Administrator() == 'Administrator')
                    <div class="form-group col-sm-3 col-xs-3">
                        {!! Form::select('merchant', $merchant, null, ['class' => 'form-control']) !!}
                    </div>
                    @endif

                    <div class="form-group col-sm-3 col-xs-3">
                        {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                    </div>
                    <div class="form-group col-sm-3 col-xs-3">
                        {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search" ></span> {{__('administrator.searching')}} </button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"style="display: none" ><span class="fa fa-print" ></span>   {{__('administrator.print')}}</button>
                            <button type="button" class="button_sm button_primary pull-right show_payall "style="display: none"><i class="fa fa-dollar" ></i>  Pay All</button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="example" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th> </th>
                    <th>{{__('administrator.no')}}</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.price')}}</th>
                    <th>{{__('administrator.price_of_car')}}</th>
                    <th>{{__('administrator.price_of_service')}}</th>
                    <th>{{__('administrator.extra_fee')}}</th>
                    <th>{{__('administrator.service_charge')}}</th>
                    <th>{{__('administrator.total')}}</th>
                </tr>
            </thead>
            <tfoot>

            </tfoot>
        </table>
    </div>
</div>


@endsection

@section('script')
<script type="text/javascript">
    function format (d) {
        var tbody_1  ='';
        $.ajax({
            url: "{{route('paymente_show')}}",
            type: 'GET',
            dataType: 'json',
            data: {
                merchant_id: d.merchant_id,
                delivery_date: d.delivery_date,
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                $('.tbody_1').empty();
                $total = 0;


            }
        });

        var div = '<table cellpadding="5" class="table" cellspacing="0" border="0" style="back">'+
            '<thead>'+
                '   <tr>'+
                    ' <th>{{__('administrator.no')}}</th>'+
                    '<th>{{__('administrator.driver')}}</th>'+
                    ' <th>{{__('administrator.box_code')}}</th>'+
                    '<th>{{__('administrator.location')}}</th>'+
                    '<th>{{__('administrator.customer_receive')}}</th>'+
                    ' <th>{{__('administrator.price')}}</th>'+
                    '<th>{{__('administrator.price_of_car')}}</th>'+
                    ' <th>{{__('administrator.price_of_service')}}</th>'+
                    '<th>{{__('administrator.extra_fee')}}</th>'+
                    '<th>{{__('administrator.service_charge')}}</th>'+
                    '<th>{{__('administrator.total')}}</th>'+
                ' </tr>'+
            '</thead>'+
            '<tbody id="tbOdy">'+
            '</tbody>'+


        '</table>';
        return div;
    }

    $(document).ready(function() {
        var dt = $('#example').DataTable( {
            "processing": true,
            "serverSide": true,
            "ajax": "{{route('datatable_payment')}}",
            "columns": [
                {
                    "class":            "details-control",
                    "orderable":        false,
                    "data":             null,
                    "defaultContent"    : ""
                },
                {data: 'DT_RowIndex'},
                {data: 'delivery_date'},
                {data: 'shop_name'},
                {data: 'total_price'},
                {data: 'total_taxi_fee'},
                {data: 'total_delivery_fee'},
                {data: 'total_extra_fee'},
                {data: 'total_service_charge'},
                {data: 'total'},
            ],
            "order": [[1, 'asc']]
        } );

        var detailRows = [];

        $('#example tbody').on( 'click', 'tr td.details-control', function () {
            var tr = $(this).closest('tr');
            var row = dt.row( tr );
            var idx = $.inArray( tr.attr('id'), detailRows );

            if ( row.child.isShown() ) {
                tr.removeClass( 'details' );
                row.child.hide();

                // Remove from the 'open' array
                detailRows.splice( idx, 1 );
            }
            else {
                tr.addClass( 'details' );
                row.child( format( row.data() ) ).show();

                // Add to the 'open' array
                if ( idx === -1 ) {
                    detailRows.push( tr.attr('id') );
                }
            }
        } );

        dt.on( 'draw', function () {
            $.each( detailRows, function ( i, id ) {
                $('#'+id+' td.details-control').trigger( 'click' );
            } );
        } );
    } );

    function dd(tbody_1){

        $('#tbOdy').append(tbody_1);


    }

</script>
@stop



